/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge;

import com.mojang.brigadier.CommandDispatcher;
import io.github.kosmx.emotes.arch.ServerCommands;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.forge.ClientCommands;
import io.github.kosmx.emotes.forge.ClientInit;
import io.github.kosmx.emotes.forge.executor.ForgeEmotesMain;
import io.github.kosmx.emotes.forge.network.ServerNetwork;
import io.github.kosmx.emotes.main.MainLoader;
import java.util.logging.Level;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="emotecraft")
public class ForgeWrapper {
    public static final Logger logger = LoggerFactory.getLogger((String)"emotecraft");

    public ForgeWrapper() {
        EmoteInstance.instance = new ForgeEmotesMain();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        ServerCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getEnvironment().equals((Object)Commands.CommandSelection.DEDICATED));
    }

    @SubscribeEvent
    public void clientCommandRegister(RegisterClientCommandsEvent event) {
        ClientCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void setup(FMLCommonSetupEvent event) {
        MainLoader.main(new String[]{"FML"});
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ClientInit.initClient();
        }
        ServerNetwork.instance.init();
    }

    public static void log(Level level, String msg) {
        if (level.intValue() <= Level.INFO.intValue()) {
            logger.debug(msg);
        } else if (level.intValue() <= Level.WARNING.intValue()) {
            logger.warn(msg);
        } else {
            logger.error(msg);
        }
    }
}

